<%

' <!-- DESCRIPTION OF PAGE -->
	' <!-- This page is designed to build, accept and show votes -->

' <!-- CREATED BY: -->
	' <!-- Tim Hancock -->

' <!-- DATE CREATED: -->
	' <!-- 17/05/2001 -->

' <!-- MODIFICATIONS: Date, Name, Modification -->

' <!-- THIS PAGE IS CALLED BY: -->
	' <!-- Any Page -->

' <!-- ACTIONS: -->
	' <!-- Take the action to be performed, the vote id from the URL and based upon that peform certain tasks -->
	
' <!-- Get the Action to be performed -->
strAction = Request.QueryString("ACTION")

' <!-- Test the action. If nothing is retrieved, assume the user wants to administrate all available votes -->
If strAction = "" Then
	strAction = "AdminViewAll"
End if


' <!-- ################################# OPEN THE DATABASE CONNECTION ################################# -->

' <!-- Declare our object variables used in connecting to the database-->
Set adoRS = Server.CreateObject("ADODB.Recordset")
Set adoConn = Server.CreateObject("ADODB.Connection")
' <!-- Open the database connection -->
adoConn.Open "VotesODBC"

' <!-- ################################# END: OPEN THE DATABASE CONNECTION ################################# -->


' <!-- ################################# FUNCTIONS ################################# -->

' <!-- This function produces the header bar at the top of the page -->
Function AdministratorHeader()
	%>

	<HTML>
	<BODY bgcolor="white" topmargin=0 leftmargin=0 rightmargin=0 marginheight=0 marginwidth=0>
	<!-- The administrator options -->
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tr bgcolor="navy">
			<td nowrap height="25" align="center">
				<font face="verdana,arial" size="1" color="white">
					<b>
						&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminViewAll" style="text-decoration:none; color:white">
							View All Votes
						</a>
						&nbsp;&nbsp;|&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminVoteAddUpdate" style="text-decoration:none; color:white">
							Add/Update A Vote
						</a>
						&nbsp;&nbsp;|&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminVoteOptionAddUpdate" style="text-decoration:none; color:white">
								Add/Update A Vote Option
						</a>
						&nbsp;&nbsp;|&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminVoteDelete" style="text-decoration:none; color:white">
							Delete A Vote
						</a>
						&nbsp;&nbsp;|&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminVoteOptionDelete" style="text-decoration:none; color:white">
							Delete A Vote Option
						</a>
						&nbsp;&nbsp;|&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminShowVoteStatistics" style="text-decoration:none; color:white">
							Show Statistics
						</a>
						&nbsp;&nbsp;|&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminShowVoters" style="text-decoration:none; color:white">
							Show Voters
						</a>
						&nbsp;&nbsp;|&nbsp;&nbsp;
						<a href="Votes.asp?ACTION=AdminShowHelp" style="text-decoration:none; color:white">
							How To Use
						</a>
					</b>
				</font>
			</td>
		</tr>
	</table>
	<!-- End administrator options -->
	<%
	' <!-- First time the page is called, it will be unprotected unless we add a password form -->
	if Request.Cookies("UserName") = "" Then
		' <!-- Present a user name and password form -->
		%>
		<center>
		<br>
		<br>
		<form name="Authorise" action="Votes.asp?ACTION=Authorise" target="_self" method="post">
			User name:<input type="text" name="UserName" size="15"><br>
			Password: <input type="password" name="Password" size="15"><br>
			<input type="submit" value="Administrator Login">
		</form>
		<%
		' <!-- Stop processing the page -->
		Response.End
	End if

End Function

' <!-- This function produces the header the user will see -->
Function UserHeader()
	
	%>
	<HTML>
	<BODY bgcolor="white" topmargin=0 leftmargin=0 rightmargin=0 marginheight=0 marginwidth=0>
	<BR>
	<BR>
	<%

End Function


' <!-- This function adds or updates the Votes description -->
Function AddUpdateVoteDescription(iVoteID, strVoteDescription)

	' <!-- Declare our local ADO variables -->
	Set lclAdoRS = Server.CreateObject("ADODB.Recordset")
	
	' <!-- Construct the SQL statement -->
	If iVoteID <> "" Then
		' <!-- Update the text of a specific vote -->
		strSQL = "SELECT Description FROM VotesDescription WHERE ID = " & iVoteID
	Else
		' <!-- Check that the user hasn't re-entered an existing vote -->
		strSQL = "SELECT Description FROM VotesDescription WHERE Description = '" & strVoteDescription & "'"
	End if

	' <!-- Open the recordset with update intent -->
	lclAdoRS.Open strSQL, adoConn, 3, 3

	' <!-- Test if the record exists, otherwise add a new record -->
	If lclAdoRS.EOF = True Then
		lclAdoRS.AddNew
	End if

	' <!-- Assign the description -->
	lclAdoRS("Description") = strVoteDescription

	' <!-- Update the recordset -->
	lclAdoRS.Update

	' <!-- Close the recordset and release the resources -->
	lclAdoRS.Close
	Set lclAdoRS = Nothing

End Function

' <!-- This function adds or updates the Values of the votes -->
Function AddUpdateVoteValue(iVoteID, iVoteValueID, strVoteValueDescription)

	' <!-- Declare our local ADO variables -->
	Set lclAdoRS = Server.CreateObject("ADODB.Recordset")
	
	' <!-- Construct the SQL statement -->
	If iVoteValueID <> "" Then
		' <!-- Update the text of a specific vote -->
		strSQL = "SELECT VoteID, ValueDescription FROM VotesValues WHERE VoteID = " & iVoteID & " AND Value = " & iVoteValueID
	Else
		' <!-- Check that the user hasn't re-entered an existing vote -->
		strSQL = "SELECT VoteID, ValueDescription FROM VotesValues WHERE VoteID = " & iVoteID & " AND ValueDescription = '" & strVoteValueDescription & "'"
	End if

	' <!-- Open the recordset with update intent -->
	lclAdoRS.Open strSQL, adoConn, 3, 3

	' <!-- Test if the record exists, otherwise add a new record -->
	If lclAdoRS.EOF = True Then
		lclAdoRS.AddNew
	End if

	' <!-- Assign the value description -->
	lclAdoRS("ValueDescription") = strVoteValueDescription
	lclAdoRS("VoteID") = iVoteID

	' <!-- Update the recordset -->
	lclAdoRS.Update

	' <!-- Close the recordset and release the resources -->
	lclAdoRS.Close
	Set lclAdoRS = Nothing

End Function

' <!-- This function deletes the votes -->
Function DeleteVote(iVoteID)

	' <!-- Construct the SQL statement that deletes the options -->
	strSQL = "DELETE VotesValues WHERE VoteID = " & iVoteID
	' <!-- Execute the SQL -->
	adoConn.Execute(strSQL)

	' <!-- Construct the SQL statement that deletes the votes cast -->
	strSQL = "DELETE VotesCast WHERE VoteID = " & iVoteID
	' <!-- Execute the SQL -->
	adoConn.Execute(strSQL)

	' <!-- Construct the SQL statement that deletes the votes details -->
	strSQL = "DELETE VotesDescription WHERE ID = " & iVoteID
	' <!-- Execute the SQL -->
	adoConn.Execute(strSQL)

End Function

' <!-- This function deletes the votes -->
Function DeleteVoteValue(iVoteID, iVoteValueID)

	' <!-- Construct the SQL statement that deletes the options -->
	strSQL = "DELETE VotesValues WHERE VoteID = " & iVoteID & " AND Value = " & iVoteValueID
	' <!-- Execute the SQL -->
	adoConn.Execute(strSQL)

End Function

' <!-- This function shows the statistics for a given vote -->
Function ShowStatistics(iVoteID)

	' <!-- Declare the local ADO variables -->
	Set lclAdoRS = Server.CreateObject("ADODB.Recordset")

	' <!-- Get the description -->
	Description = GetDescription(iVoteID)

	' <!-- create the SQL string that retrieves the total number of votes cast -->
	strSQL = "SELECT COUNT(Value) As VotesMade FROM VotesCast WHERE VoteID = " & iVoteID
	' <!-- Open the recordset -->
	lclAdoRS.Open strSQL, adoConn
	' <!-- Get the total number of votes cast to use in calculating the percentage -->
	TotalVotes = lclAdoRS("VotesMade")
	' <!-- Close the recordset -->
	lclAdoRS.Close

	' <!-- Now create the table -->
	%>
	
	<!-- Build a table to show the actual voting -->
	<TABLE bgColor=#000000 border=0 cellPadding=0 cellSpacing=0 width=250>
    	<TR>
      		<TD align=middle>
          	 	<TABLE border=0 cellPadding=0 cellSpacing=1 width=100%>        	
		            <TR>
						<!-- The Header Row Contains the vote description -->
						<th colspan="2" bgColor=#3B65DD><font face="verdana,helvetica,arial" size="1" color="white">
							<%= Description %>
						</th>
					</tr>
					<% 
					' <!-- Now get each individual number of votes -->
					strSQL = "SELECT COUNT(VotesCast.Value) AS VotesMade, " _ 
	   							& "VotesValues.ValueDescription, VotesValues.Value " _
								& "FROM VotesCast INNER JOIN " _
	    						& "VotesValues ON VotesCast.VoteID = VotesValues.VoteID AND " _
	    						& "VotesCast.Value = VotesValues.Value " _
								& "WHERE (VotesCast.VoteID = " & iVoteID & ") " _
								& "GROUP BY VotesValues.ValueDescription, VotesValues.Value"
					' <!-- Open the recordset -->
					lclAdoRS.Open strSQL, adoConn
					' <!-- Loop through the record set -->
					Do While Not lclAdoRS.EOF 
						If lclAdoRS("VotesMade") <> "" Then 
							VotesPercentage = FormatPercent(lclAdoRS("VotesMade")/TotalVotes,0) 
							VotesP = lclAdoRS("VotesMade")/TotalVotes
						else
							VotesPercentage = "0%" 
						end if %>
						<tr>
							<td height="20" bgcolor="white" width="50%">
								<table cellpadding="3">
									<tr>
										<td><font face="verdana,helvetica,arial" size="1"><%= lclAdoRS("ValueDescription") %></td>
									</tr>
								</table>
							</td>
							<td bgcolor="white">
								<table width="<%= VotesPercentage %>" bgcolor="blue" cellpadding="0" cellspacing="0">
									<tr><td align="right"><img src="/images/1pixel.gif" height="5"></img></td></tr>
								</table>
								<font face="verdana,helvetica,arial" size="1" color="black"><%= VotesPercentage %>
							</td>
						</tr>
						<% lclAdoRS.MoveNext
					Loop
					lclAdoRS.Close %>
				</table>
			</td>
		</tr>	
	</table>
	<BR>

	<%
	
	' <!-- Free the resources -->
	Set lclAdoRS = Nothing

End Function

Function ShowForm(iVoteID, strPreviousAction, strShowStatistics)
	
	' <!-- Create our local ADO variables -->
	Set lclAdoRS = Server.CreateObject("ADODB.Recordset")

	' <!-- Get the description -->
	Description = GetDescription(iVoteID)

	' <!-- Create the voting form -->
	%>
	<!-- The voting form -->
	<form name="VotesForm" action="Votes.asp?ACTION=VoteCast&NextAction=<%= strShowStatistics %>" target="_self" method="post">
		<input type="hidden" name="VoteID" value="<%= iVoteID %>">
		
		<!-- Build a table to store the actual voting options in a uniform manner -->
		<TABLE bgColor=#000000 border=0 cellPadding=0 cellSpacing=0 width=250>
		    <TR>
		      	<TD align=middle>
		           	<TABLE border=0 cellPadding=0 cellSpacing=1 width=100%>        	
			            <TR>
							<!-- The Header Row Contains the vote description -->
							<th bgColor=#3B65DD><font face="verdana,helvetica,arial" size="1" color="white">
								<%= Description %>
							</th>
						</tr>
						<% 
						' <!-- Now Return all the available options -->
						strSQL = "SELECT VoteID, Value, ValueDescription FROM VotesValues WHERE VoteID = " & iVoteID & " ORDER BY Value"
						' <!-- Open the recordset -->
						lclAdoRS.Open strSQL, adoConn
						' <!-- Loop through the record set -->
						Do While Not lclAdoRS.EOF %>
						<tr>
							<td valign="middle" bgcolor="white">
								<input type="radio" name="VoteOption" value="<%= lclAdoRS("Value") %>">
								<font face="verdana,helvetica,arial" size="1"><%= lclAdoRS("ValueDescription") %>
							</td>
						</tr>
						<% lclAdoRS.MoveNext
						Loop
						lclAdoRS.Close %>
					</table>
				</td>
			</tr>
			
			
		</table>
		
		<BR>
		<table width=250>
			<tr>
				<td width=125 align="center">
					<a href="javascript:this.document.VotesForm.submit()"><img src="/Images/VoteNow.jpg" border="0"></img></a>
				</td>
				<td width=125 align="center">
					<a href="Votes.asp?ACTION=<%= strShowStatistics %>&SUBACTION=Show&VoteID=<%= iVoteID %>"><img src="/Images/ViewResults.jpg" border="0"></img></a>
				</td>
				
			</tr>
		</table>
		
	</form>
		
	<%
	
	' <!-- release the resources -->
	Set lclAdoRS = Nothing

End Function

' <!-- This function gets the vote description -->
Function GetDescription(iVoteID)

	' <!-- Create our local ADO variable -->
	Set lclAdoRS = Server.CreateObject("ADODB.Recordset")

	' <!-- Create the SQL string that retrieves the vote description -->
	strSQL = "SELECT Description FROM VotesDescription WHERE ID = " & iVoteID
	' <!-- Open the record set -->
	lclAdoRS.open strSQL, adoConn
	' <!-- Get the description of the vote -->
	Description = lclAdoRS("Description")
	' <!-- Close the recordset -->
	lclAdoRS.Close
	' <!-- Free the resources -->
	Set lclAdoRS = Nothing

	' <!-- Return the description -->
	GetDescription = Description

End Function

' <!-- This function registers the users vote -->
Function RegisterVote(iVoteID, iVoteValueID, strNextAction)

	' <!-- Perform error checking on the values passed -->
	If iVoteValueID <> "" Then
		
		' <!-- Get the users IP address -->
		RemoteHost = Request.ServerVariables("REMOTE_HOST")
	
		' <!-- Add the vote to the database -->
		strSQL = "INSERT INTO VotesCast (VoteID, Value, VotedBy) VALUES (" & iVoteID & ", " & iVoteValueID & ", '" & RemoteHost & "')"
	
		' <!-- Add the data -->
		adoConn.Execute(strSQL)

	End if

	' <!-- Redirect the user to the page they came from -->
	Response.Redirect "Votes.asp?ACTION=" & strNextAction & "&SUBACTION=Show&VoteID=" & iVoteID

End Function

' <!-- This function shows the statistics for a given vote -->
Function ShowVoters(iVoteID)

	' <!-- Declare the local ADO variables -->
	Set lclAdoRS = Server.CreateObject("ADODB.Recordset")
	Set lclAdoRSOptions = Server.CreateObject("ADODB.Recordset")

	' <!-- Get the description -->
	Description = GetDescription(iVoteID)

	' <!-- Show a list of voters for each option given -->
	' <!-- Construct the SQL string that gets all the options -->
	strSQL = "SELECT * FROM VotesValues WHERE VoteID = " & iVoteID	
	
	' <!-- Open the recordset -->
	lclAdoRS.Open strSQL, adoConn, 3
		
	' <!-- Loop through the recordset -->
	Do While lclAdoRS.EOF = False 
		
		' <!-- Present the description of the vote option -->
		%>
		<h3><%= lclAdoRS("ValueDescription") %></h3>
		<br>
		<font face="verdana,arial" size=1>
		<%
		' <!-- Now get all the people that voted for that option -->
		strSQL = "SELECT VotedBy, COUNT(VotedBy) As iCount FROM VotesCast WHERE VoteID = " & iVoteID & " AND Value = " & lclAdoRS("Value") & " GROUP BY VotedBy"
		' <!-- Open the recordset -->
		lclAdoRSOptions.Open strSQL, adoConn, 3
		' <!-- Loop through the recordset -->
		Do While lclAdoRSOptions.EOF = False
			%>
			<%= lclAdoRSOptions("VotedBy") %> = <%= lclAdoRSOptions("iCount") %> Votes<br>
			<%
			' <!-- Move to the next record -->
			lclAdoRSOptions.MoveNext
		Loop
		' <!-- Close the recordset -->
		lclAdoRSOptions.Close
		' <!-- get the next vote value -->
		lclAdoRS.MoveNext
	Loop

	' <!-- Close the recordset -->
	lclAdoRS.Close

	' <!-- Free the resources -->
	Set lclAdoRS = Nothing
	Set lclAdoRSOptions = Nothing

End Function

' <!-- ################################# END: FUNCTIONS ################################# -->
		



' <!-- ################################# DISPLAY DATA BASED ON USER INPUT ################################# -->

' <!-- Use a select statement to determine the cause of action -->
Select Case strAction

	' <!-- ################################# ADMIN: AUTHORISATION ################################# -->
	Case "Authorise"
		
		' <!-- Get the user name and password from the submitting form -->
		strUserName = Request.Form("UserName")
		strPassword = Request.Form("Password")

		' <!-- Test the values -->
		If strUserName = "AdminUser" and strPassword = "AdminPassWord" Then
			' <!-- Store the value in a cookie -->
			Response.Cookies("UserName") = strUserName
			
		Else
			' <!-- Do Nothing. By not storing a user name, the user name box will be prompted again -->
		End if
		' <!-- Redirect the user to the correct action -->
		Response.Redirect "Votes.asp?ACTION=AdminShowHelp"
 		Response.End

	' <!-- ################################# ADMIN: VIEW ALL VOTES ################################# -->
	Case "AdminViewAll"
		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: View All Votes</h2>
		<br>
		<br>
		<table width="50%" border="0" cellpadding="0" cellspacing="0">
		<%
		' <!-- Retrieve all the Vote Titles we have created -->
		strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
		' <!-- Open the recordset -->
		adoRS.Open strSQL, adoConn
		' <!-- Scroll through the recordset until the end -->
		Do While Not adoRS.EOF %>
			<tr>
				<td>
					<font face="verdana,arial" size="1">
					<%= adoRS("Description") %>
				</td>
				<td>
					<font face="verdana,arial" size="1">
					<a href="Votes.asp?ACTION=AdminCastVote&SUBACTION=Show&VoteID=<%= adoRS("ID") %>" title="Vote">
						Vote
					</a>
				</td>
			</tr>
		<% 
			' <!-- Move to the next record -->
			adoRS.MoveNext
		Loop
		' <!-- Close the recordset -->
		adoRS.Close
		' <!-- Release the resource -->
		Set adoRS = Nothing
		%>
		</table>
		</center>
		<%
		' <!-- Stop the page running any further -->
		Response.End 

	' <!-- ################################# USER: VIEW ALL VOTES ################################# -->
	Case "UserViewAll"

		%>
		<center>
		<%= UserHeader() %>	
		<h2>View All Votes</h2>
		<br>
		<br>
		<table width="50%" border="0" cellpadding="0" cellspacing="0">
		<%
		' <!-- Retrieve all the Vote Titles we have created -->
		strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
		' <!-- Open the recordset -->
		adoRS.Open strSQL, adoConn
		' <!-- Scroll through the recordset until the end -->
		Do While Not adoRS.EOF %>
			<tr>
				<td>
					<font face="verdana,arial" size="1">
					<%= adoRS("Description") %>
				</td>
				<td>
					<font face="verdana,arial" size="1">
					<a href="Votes.asp?ACTION=UserCastVote&SUBACTION=Show&VoteID=<%= adoRS("ID") %>" title="Vote">
						Vote
					</a>
				</td>
			</tr>
		<% 
			' <!-- Move to the next record -->
			adoRS.MoveNext
		Loop
		' <!-- Close the recordset -->
		adoRS.Close
		' <!-- Release the resource -->
		Set adoRS = Nothing
		%>
		</table>
		</center>
		<%
		' <!-- Stop the page running any further -->
		Response.End 

	' <!-- ################################# ADMIN: ADD/UPDATE A VOTE ################################# -->
	Case "AdminVoteAddUpdate"

		' <!-- Retrieve the sub action, if any that will determine whether we are updating or adding -->
		strSubAction = Request.QueryString("SUBACTION")
		' <!-- Test if we have been submitted data -->
		If strSubAction <> "" Then
			' <!-- Get the data required to add/update -->
			iVoteID = Request.Form("VoteID")
			strDescription = Request.Form("VoteName")
			' <!-- Call the function that adds/updates the record -->
			Call AddUpdateVoteDescription(iVoteID, strDescription)
		End if

		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Add/Update A Votes</h2>
		<br>
		<br>
		<table width="50%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>Description</b></font>
				</td>
				<td>
					<font face="verdana,arial" size="2"><b>Action</b></font>
				</td>
			</tr>
		<%
		' <!-- Retrieve all the Vote Titles we have created -->
		strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
		' <!-- Open the recordset -->
		adoRS.Open strSQL, adoConn
		' <!-- Scroll through the recordset until the end -->
		Do While Not adoRS.EOF %>
			<tr>
				<!-- Use a form to submit changes -->
				<form name="VoteUpdate<%= adoRS("ID") %>" action="Votes.asp?ACTION=AdminVoteAddUpdate&SUBACTION=Update" method="post">
				<input type="hidden" name="VoteID" value="<%= adoRS("ID") %>">
				<td>
					<input type="text" size=60 name="VoteName" value="<%= adoRS("Description") %>">
				</td>
				<td>
					<input type="submit" value="Update">
				</td>
				</form>
			</tr>
		<% 
			' <!-- Move to the next record -->
			adoRS.MoveNext
		Loop
		' <!-- Close the recordset -->
		adoRS.Close
		' <!-- Release the resource -->
		Set adoRS = Nothing
		%>
			<tr>
				<!-- Use a form to add new votes -->
				<form name="VoteUpdateNew" action="Votes.asp?ACTION=AdminVoteAddUpdate&SUBACTION=Add" method="post">
				<td>
					<input type="text" size=60 name="VoteName"">
				</td>
				<td>
					<input type="submit" value="Add">
				</td>
				</form>
			</tr>
		</table>
		</center>
		<%
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# ADMIN: ADD/UPDATE A VOTE OPTION ################################# -->
	Case "AdminVoteOptionAddUpdate"

		' <!-- Retrieve the sub action, if any that will determine whether we are updating or adding -->
		strSubAction = Request.QueryString("SUBACTION")
		' <!-- Test if we have been submitted data -->
		Select Case strSubAction 
			Case "View"
				' <!-- Get the data required to view -->
				iVoteID = Request.Form("VoteID")
			Case "Update"
				' <!-- Get the data required to update and entry -->
				iVoteID = Request.Form("VoteID")
				iValueID = Request.Form("ValueID")
				strValueDescription = Request.Form("ValueDescription")
				' <!-- Call the routine that adds the data -->
				Call AddUpdateVoteValue(iVoteID, iValueID, strValueDescription)
				' <!-- Change the action to view -->
				strSubAction = "View"
			Case "Add"
				' <!-- Get the data required to update and entry -->
				iVoteID = Request.Form("VoteID")
				strValueDescription = Request.Form("ValueDescription")
				' <!-- Call the routine that adds the data -->
				Call AddUpdateVoteValue(iVoteID, "", strValueDescription)
				' <!-- Change the action to view -->
				strSubAction = "View"
		End Select

		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Add/Update A Votes Option</h2>
		<br>
		<br>
		<table width="50%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>Choose A Vote</b></font>
				</td>
			</tr>
			<tr>
				<td>
					<!-- Use a form to submit changes -->
					<form name="VoteOptionUpdate" action="Votes.asp?ACTION=AdminVoteOptionAddUpdate&SUBACTION=View" method="post">
					<select name="VoteID">
					<%
					' <!-- Retrieve all the Vote Titles we have created -->
					strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
					' <!-- Open the recordset -->
					adoRS.Open strSQL, adoConn
					' <!-- Scroll through the recordset until the end -->
					Do While Not adoRS.EOF %>
						<option value="<%= adoRS("ID") %>" <% If iVoteID = CStr(adoRS("ID")) Then Response.Write("selected") End if %>><%= adoRS("Description") %>
						<% 
						' <!-- Move to the next record -->
						adoRS.MoveNext
					Loop
					' <!-- Close the recordset -->
					adoRS.Close
					%>
					</select>
					<input type="submit" value="View Options">
				</td>
				</form>
			</tr>
			<%
			' <!-- Test if we are required to show all the sub options -->
			If strSubAction = "View" Then
				%>
				<tr>
					<!-- Header Row -->
					<td>
						<font face="verdana,arial" size="2"><b>Description</b></font>
					</td>
					<td>
						<font face="verdana,arial" size="2"><b>Action</b></font>
					</td>
				</tr>
				<%
				' <!-- Retrieve all the Vote Titles we have created -->
				strSQL = "SELECT VoteID, Value, ValueDescription FROM VotesValues WHERE VoteID = " & iVoteID
				' <!-- Open the recordset -->
				adoRS.Open strSQL, adoConn
				' <!-- Scroll through the recordset until the end -->
				Do While Not adoRS.EOF 
					%>
					<tr>
						<!-- Use a form to submit changes -->
						<form name="VoteOptionUpdate<%= iVoteID %>" action="Votes.asp?ACTION=AdminVoteOptionAddUpdate&SUBACTION=Update" method="post">
						<input type="hidden" name="VoteID" value="<%= iVoteID %>">
						<input type="hidden" name="ValueID" value="<%= adoRS("Value") %>">
						
						<td>
							<input type="text" size=60 name="ValueDescription" value="<%= adoRS("ValueDescription") %>">
						</td>
						<td>
							<input type="submit" value="Update">
						</td>
						</form>
					</tr>
					<% 
					' <!-- Move to the next record -->
					adoRS.MoveNext
				Loop
				' <!-- Close the recordset -->
				adoRS.Close
				' <!-- Release the resource -->
				Set adoRS = Nothing
				%>
				<tr>
					<!-- Use a form to add new votes -->
					<form name="VoteOptionUpdateNew" action="Votes.asp?ACTION=AdminVoteOptionAddUpdate&SUBACTION=Add" method="post">
					<input type="hidden" name="VoteID" value="<%= iVoteID %>">
					<td>
						<input type="text" size=60 name="ValueDescription">
					</td>
					<td>
						<input type="submit" value="Add">
					</td>
					</form>
				</tr>
			<% End If %>
		</table>
		</center>
		<%	
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# ADMIN: DELETE A VOTE ################################# -->
	Case "AdminVoteDelete"

		' <!-- Retrieve the sub action, if any that will determine whether we are updating or adding -->
		strSubAction = Request.QueryString("SUBACTION")
		' <!-- Test if we have been submitted data -->
		Select Case strSubAction 
			Case "Delete"
				' <!-- Get the data required to view -->
				iVoteID = Request.Form("VoteID")
				' <!-- Call the routine that deletes the vote -->
				Call DeleteVote(iVoteID)
		End Select

		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Delete A Vote Option</h2>
		<br>
		<br>
		<table width="50%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>Choose A Vote</b></font>
				</td>
			</tr>
			<tr>
				<td>
					<!-- Use a form to submit changes -->
					<form name="VoteDelete" action="Votes.asp?ACTION=AdminVoteDelete&SUBACTION=Delete" method="post">
					<select name="VoteID">
					<%
					' <!-- Retrieve all the Vote Titles we have created -->
					strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
					' <!-- Open the recordset -->
					adoRS.Open strSQL, adoConn
					' <!-- Scroll through the recordset until the end -->
					Do While Not adoRS.EOF %>
						<option value="<%= adoRS("ID") %>"><%= adoRS("Description") %>
						<% 
						' <!-- Move to the next record -->
						adoRS.MoveNext
					Loop
					' <!-- Close the recordset -->
					adoRS.Close
					%>
					</select>
					<input type="submit" value="Delete Vote">
				</td>
				</form>
			</tr>
		</table>
		</center>
		<%	
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# ADMIN: DELETE A VOTE OPTION ################################# -->
	Case "AdminVoteOptionDelete"

		' <!-- Retrieve the sub action, if any that will determine whether we are updating or adding -->
		strSubAction = Request.QueryString("SUBACTION")
		' <!-- Test if we have been submitted data -->
		Select Case strSubAction 
			Case "View"
				' <!-- Get the data required to view -->
				iVoteID = Request.Form("VoteID")
			Case "Delete"
				' <!-- Get the data required to update and entry -->
				iVoteID = Request.Form("VoteID")
				iValueID = Request.Form("ValueID")
				' <!-- Call the routine that adds the data -->
				Call DeleteVoteValue(iVoteID, iValueID)
				' <!-- Change the action to view -->
				strSubAction = "View"
		End Select

		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Delete A Votes Option</h2>
		<br>
		<br>
		<table width="50%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>Choose A Vote</b></font>
				</td>
			</tr>
			<tr>
				<td>
					<!-- Use a form to submit changes -->
					<form name="VoteOptionDelete" action="Votes.asp?ACTION=AdminVoteOptionDelete&SUBACTION=View" method="post">
					<select name="VoteID">
					<%
					' <!-- Retrieve all the Vote Titles we have created -->
					strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
					' <!-- Open the recordset -->
					adoRS.Open strSQL, adoConn
					' <!-- Scroll through the recordset until the end -->
					Do While Not adoRS.EOF %>
						<option value="<%= adoRS("ID") %>" <% If iVoteID = CStr(adoRS("ID")) Then Response.Write("selected") End if %>><%= adoRS("Description") %>
						<% 
						' <!-- Move to the next record -->
						adoRS.MoveNext
					Loop
					' <!-- Close the recordset -->
					adoRS.Close
					%>
					</select>
					<input type="submit" value="View Options">
				</td>
				</form>
			</tr>
			<%
			' <!-- Test if we are required to show all the sub options -->
			If strSubAction = "View" Then
				%>
				<tr>
					<!-- Header Row -->
					<td>
						<font face="verdana,arial" size="2"><b>Description</b></font>
					</td>
					<td>
						<font face="verdana,arial" size="2"><b>Action</b></font>
					</td>
				</tr>
				<%
				' <!-- Retrieve all the Vote Titles we have created -->
				strSQL = "SELECT VoteID, Value, ValueDescription FROM VotesValues WHERE VoteID = " & iVoteID
				' <!-- Open the recordset -->
				adoRS.Open strSQL, adoConn
				' <!-- Scroll through the recordset until the end -->
				Do While Not adoRS.EOF 
					%>
					<tr>
						<!-- Use a form to submit changes -->
						<form name="VoteOptionDelete<%= iVoteID %>" action="Votes.asp?ACTION=AdminVoteOptionDelete&SUBACTION=Delete" method="post">
						<input type="hidden" name="VoteID" value="<%= iVoteID %>">
						<input type="hidden" name="ValueID" value="<%= adoRS("Value") %>">
						
						<td>
							<input type="text" size=60 name="ValueDescription" value="<%= adoRS("ValueDescription") %>">
						</td>
						<td>
							<input type="submit" value="Delete">
						</td>
						</form>
					</tr>
					<% 
					' <!-- Move to the next record -->
					adoRS.MoveNext
				Loop
				' <!-- Close the recordset -->
				adoRS.Close
				' <!-- Release the resource -->
				Set adoRS = Nothing
			End If %>
		</table>
		</center>
		<%	
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# ADMIN: A VOTE IS TO BE CAST ################################# -->
	Case "AdminCastVote"

		' <!-- Retrieve the sub action, if any that will determine whether we are updating or adding -->
		strSubAction = Request.QueryString("SUBACTION")
		' <!-- Test if we have been submitted data -->
		Select Case strSubAction
			Case "Show"
				' <!-- Get the data required to add/update -->
				iVoteID = Request.Form("VoteID")
				' <!-- Test if we have submitted the request from a form, and as such, the ID is in the URL -->
				If iVoteID = "" Then
					iVoteID = Request.QueryString("VoteID")
				End if
		End Select

		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Cast A Vote</h2>
		<br>
		<br>
			<table width="50%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>Choose A Vote</b></font>
				</td>
			</tr>
			<tr>
				<td>
					<!-- Use a form to submit changes -->
					<form name="VoteCast" action="Votes.asp?ACTION=AdminCastVote&SUBACTION=CastVote" method="post">
					<select name="VoteID">
					<%
					' <!-- Retrieve all the Vote Titles we have created -->
					strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
					' <!-- Open the recordset -->
					adoRS.Open strSQL, adoConn
					' <!-- Scroll through the recordset until the end -->
					Do While Not adoRS.EOF %>
						<option value="<%= adoRS("ID") %>" <% If iVoteID = CStr(adoRS("ID")) Then Response.Write("selected") End If %>><%= adoRS("Description") %>
						<% 
						' <!-- Move to the next record -->
						adoRS.MoveNext
					Loop
					' <!-- Close the recordset -->
					adoRS.Close
					%>
					</select>
					<input type="submit" value="Show Options">
				</td>
				</form>
			</tr>
		</table>
		<br>
		<%
		' <!-- Test if we have been submitted data -->
		If strSubAction = "Show" Then
			' <!-- Call the function that produces the statistics for the user -->
			Call ShowForm(iVoteID, strAction, "AdminShowVoteStatistics")
		End if
		%>
		</center>
		<%
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# USER: A VOTE IS TO BE CAST ################################# -->
	Case "UserCastVote"

		' <!-- The user part of the system depends on the ID of the vote being passed in the URL -->
		' <!-- It can be sent as a choice made by the user, or hardcoded by the webmaster -->

		' <!-- Get the data required to show the form -->
		iVoteID = Request.Form("VoteID")
		' <!-- Test if we have submitted the request from a form, and as such, the ID is in the URL -->
		If iVoteID = "" Then
			iVoteID = Request.QueryString("VoteID")
		End if
		
		%>
		<%= UserHeader() %>	
		<center>
		<%
		' <!-- Call the function that produces the statistics for the user -->
		Call ShowForm(iVoteID, strAction, "UserShowVoteStatistics")
		%>
		</center>
		</BODY>
		</HTML>
		<%
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# A VOTE HAS BEEN CAST ################################# -->
	Case "VoteCast"

		' <!-- Get the data required to add/update -->
		iVoteID = Request.Form("VoteID")
		iValueID = Request.Form("VoteOption")
		strNextAction = Request.QueryString("NextAction")
		' <!-- Call the routine that registers the vote -->
		Call RegisterVote(iVoteID, iValueID, strNextAction)
		
	' <!-- ################################# ADMIN: SHOW VOTE STATISTICS ################################# -->
	Case "AdminShowVoteStatistics"

		' <!-- Retrieve the sub action, if any that will determine whether we are updating or adding -->
		strSubAction = Request.QueryString("SUBACTION")
		' <!-- Test if we have been submitted data -->
		If strSubAction = "Show" Then
			' <!-- Get the data required to add/update -->
			iVoteID = Request.Form("VoteID")
			' <!-- Test if we have submitted the request from a form, and as such, the ID is in the URL -->
			If iVoteID = "" Then
				iVoteID = Request.QueryString("VoteID")
			End if
		End if

		
		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Votes Statistics</h2>
		<br>
		<br>
			<table width="50%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>Choose A Vote</b></font>
				</td>
			</tr>
			<tr>
				<td>
					<!-- Use a form to submit changes -->
					<form name="VoteStatistics" action="Votes.asp?ACTION=AdminShowVoteStatistics&SUBACTION=Show" method="post">
					<select name="VoteID">
					<%
					' <!-- Retrieve all the Vote Titles we have created -->
					strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
					' <!-- Open the recordset -->
					adoRS.Open strSQL, adoConn
					' <!-- Scroll through the recordset until the end -->
					Do While Not adoRS.EOF %>
						<option value="<%= adoRS("ID") %>" <% If iVoteID = CStr(adoRS("ID")) Then Response.Write("selected") End If %>><%= adoRS("Description") %>
						<% 
						' <!-- Move to the next record -->
						adoRS.MoveNext
					Loop
					' <!-- Close the recordset -->
					adoRS.Close
					%>
					</select>
					<input type="submit" value="Show Statistics">
				</td>
				</form>
			</tr>
		</table>
		<br>
		<%
		' <!-- Test if we have been submitted data -->
		If strSubAction = "Show" Then
			' <!-- Call the function that produces the statistics for the user -->
			Call ShowStatistics(iVoteID)
		End if
		%>
		</center>
		<%
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# USER: SHOW VOTE STASTITCS ################################# -->
	Case "UserShowVoteStatistics"
		
		' <!-- The user version of show statistics receives the Vote ID from the URL or a form -->
		' <!-- Get the data required to add/update -->
		iVoteID = Request.Form("VoteID")
		' <!-- Test if we have submitted the request from a form, and as such, the ID is in the URL -->
		If iVoteID = "" Then
			iVoteID = Request.QueryString("VoteID")
		End if
		
		%>
		<HTML>
		<BODY bgcolor="white">
		<center>
		<%
		' <!-- Call the function that produces the statistics for the user -->
		Call ShowStatistics(iVoteID)
		%>
		</center>
		</BODY>
		</HTML>
		<%
		' <!-- Stop the page running any further -->
		Response.End

	' <!-- ################################# ADMIN: SHOW VOTERS ################################# -->
	Case "AdminShowVoters"

		' <!-- Retrieve the sub action, if any that will determine whether we are updating or adding -->
		strSubAction = Request.QueryString("SUBACTION")
		' <!-- Test if we have been submitted data -->
		If strSubAction = "Show" Then
			' <!-- Get the data required to add/update -->
			iVoteID = Request.Form("VoteID")
			' <!-- Test if we have submitted the request from a form, and as such, the ID is in the URL -->
			If iVoteID = "" Then
				iVoteID = Request.QueryString("VoteID")
			End if
		End if

		
		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Voters</h2>
		<br>
		<br>
			<table width="50%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>Choose A Vote</b></font>
				</td>
			</tr>
			<tr>
				<td>
					<!-- Use a form to submit changes -->
					<form name="Voters" action="Votes.asp?ACTION=AdminShowVoters&SUBACTION=Show" method="post">
					<select name="VoteID">
					<%
					' <!-- Retrieve all the Vote Titles we have created -->
					strSQL = "SELECT ID, Description FROM VotesDescription ORDER BY ID"
					' <!-- Open the recordset -->
					adoRS.Open strSQL, adoConn
					' <!-- Scroll through the recordset until the end -->
					Do While Not adoRS.EOF %>
						<option value="<%= adoRS("ID") %>" <% If iVoteID = CStr(adoRS("ID")) Then Response.Write("selected") End If %>><%= adoRS("Description") %>
						<% 
						' <!-- Move to the next record -->
						adoRS.MoveNext
					Loop
					' <!-- Close the recordset -->
					adoRS.Close
					%>
					</select>
					<input type="submit" value="Show Voters">
				</td>
				</form>
			</tr>
		</table>
		<br>
		<%
		' <!-- Test if we have been submitted data -->
		If strSubAction = "Show" Then
			' <!-- Call the function that produces the statistics for the user -->
			Call ShowVoters(iVoteID)
		End if
		%>
		</center>
		<%
		' <!-- Stop the page running any further -->
		Response.End
	
	' <!-- ################################# ADMIN: SHOW HELP ################################# -->
	Case "AdminShowHelp"

		%>
		<center>
		<%= AdministratorHeader() %>	
		<h2>Administration: Help</h2>
		<br>
		<br>
			<table width="70%" border="0" cellpadding="0" cellspacing="3">
			<tr>
				<!-- Header Row -->
				<td>
					<font face="verdana,arial" size="2"><b>How To Use This Vote Page</b></font>
				</td>
			</tr>
			<tr>
				<td nowrap><font face="verdana,arial" size="1">
					When first opened, the form will ask for a user name and password.<br>
					The values for which are set in the ACTION "authorise". These can be anything you want to use.
					The Administrator menu options are:<br>
					<b>View All Votes</b> - This shows all the existing votes and a link taking you to 
						cast a vote within the Admininstration area.<br>
					<b>Add/Update A Vote</b> - This allows you to add new votes or update titles of
						existing votes.<br>
					<b>Add/Update A Vote Option</b> - By selecting a vote title, you are presented with
						the vote options. From here you can add new options or update existing ones.<br>
					<b>Delete A Vote</b> - As it suggests, it deletes existing votes.<br>
					<b>Delete A Vote Option</b> - After selecting a vote title, you can delete a vote option.<br>
					<b>Show Statistics</b> - After selecting a vote title, this shows you the vote statistics.<br>
					<b>Show Voters</b> - After selecting a vote title, you can see the IP addresses of the voters.<br>
					<br>
					<br>
					<b>To use the page to accept user votes, do the following:</b><br>
					Pass a URL parameter called ACTION the value UserCastVote,<br>
					Pass a URL parameter called SUBACTION the value Show,<br>
					Pass a URL parameter called VoteID the value of the vote in the database.<br>
					For example, <a href="Votes.asp?ACTION=UserCastVote&SUBACTION=Show&VoteID=2">...Votes.asp?ACTION=UserCastVote&SUBACTION=Show&VoteID=2</a>
					<br>
					<br>
					<b>If you want to let the user choose the vote, do the following:</b><br>
					Pass a URL parameter called ACTION the value UserViewAll.<br>
					For example, <a href="Votes.asp?ACTION=UserViewAll">...Votes.asp?ACTION=UserViewAll</a>
					<br>
					<br>
					<b>What you need to do with a Database:</b><br>
					This page relies on 3 tables existing in a database:<br>
					<li><b>VotesDescription</b> - This table holds the main title for the vote:
						<ul>ID - Primary Key, Datatype int, Incremental Identity (or autonumber for Access)</ul>
						<ul>Description -  Datatype nvarchar (holds the description of the votes title)</ul>
						<ul>DateOfEntry -  Datatype datetime (holds the date is was created)</ul>
					</li>
					<li><b>VotesValues</b> - This table holds the options for each vote:
						<ul>VoteID - Datatype int (holds the ID of the Vote the option belongs to)</ul>
						<ul>Value -  Datatype int (a reference value for use in identifying the option)</ul>
						<ul>ValueDescription -  Datatype nvarchar (the description of the option)</ul>
					</li>
					<li><b>VotesCast</b> - This table holds the votes cast for each vote:
						<ul>VoteID - Datatype int (holds the ID of the Vote the option belongs to)</ul>
						<ul>Value -  Datatype int (a reference value for use in identifying the option voted)</ul>
						<ul>VotedBy -  Datatype nvarchar (the IP address of user name of the voter)</ul>
					</li>
					<br>
					<br>
					<b>The following SQL script should create the database for you if using MS SQL Server:</b><br>
					CREATE TABLE [dbo].[VotesCast] (<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[VoteID] [int] NULL ,<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[Value] [int] NULL ,<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[VotedBy] [nvarchar] (50) NULL<br>
					) ON [PRIMARY]<br>
					GO<br>
					<br>
					CREATE TABLE [dbo].[VotesDescription] (<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[ID] [int] IDENTITY (1, 1) NOT NULL ,<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[Description] [nvarchar] (255) NOT NULL ,<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[DateOfEntry] [datetime] NULL <br>
					) ON [PRIMARY]<br>
					GO<br>
					<br>
					CREATE TABLE [dbo].[VotesValues] (<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[VoteID] [int] NOT NULL ,<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[Value] [int] IDENTITY (1, 1) NOT NULL ,<br>
					&nbsp;&nbsp;&nbsp;&nbsp;[ValueDescription] [nvarchar] (255) NULL <br>
					) ON [PRIMARY]<br>
					GO<br>
					<br>
					ALTER TABLE [dbo].[VotesDescription] WITH NOCHECK ADD <br>
					&nbsp;&nbsp;&nbsp;&nbsp;CONSTRAINT [PK_VotesDescription] PRIMARY KEY  NONCLUSTERED <br>
					&nbsp;&nbsp;&nbsp;&nbsp;(<br>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[ID]<br>
					&nbsp;&nbsp;&nbsp;&nbsp;)  ON [PRIMARY] <br>
					GO<br>
					
					<br>
					<br>
					Then all you need to do is create a DSN entry Called "VotesODBC" which links to the database.

				</td>
				</form>
			</tr>
		</table>
		<br>
		<%
		' <!-- Test if we have been submitted data -->
		If strSubAction = "Show" Then
			' <!-- Call the function that produces the statistics for the user -->
			Call ShowVoters(iVoteID)
		End if
		%>
		</center>
		<%
		' <!-- Stop the page running any further -->
		Response.End

End Select

%>

</BODY>
</HTML>